//----------------------------------------------------------------------------//
//- CaoBoersenInfo.pas -------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// TCaoBoersenInfo kapselt alle Brsenspezifischen Daten                      //
//----------------------------------------------------------------------------//

unit CaoBoersenInfo;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, CaoBaseClass, CaoListeVonArtikelListen;

//------------------------------------------------------------------------------

type
  TCaoBoersenInfo = class (TCaoBaseClass)

  //----------------------------------------------------------------------------

  private
    m_dAbgabeBetrag               : Double;
    m_dAbgabeProzent              : Double;
    m_dtBoersenDatum              : TDateTime;
    m_dtAbschlussDatum            : TDateTime;
    m_sTitel                      : string;
    m_iStatus                     : Integer;
    m_iBoersenNummer              : Integer;
    m_obVerkaufsListe             : TCaoListeVonArtikelListen;
    m_fBoerseActive               : Boolean;

  //----------------------------------------------------------------------------

  public
    property dAbgabeBetrag         : Double
      read m_dAbgabeBetrag          write m_dAbgabeBetrag;
    property dAbgabeProzent        : Double
      read m_dAbgabeProzent         write m_dAbgabeProzent;
    property dtBoersenDatum        : TDateTime
      read m_dtBoersenDatum         write m_dtBoersenDatum;
    property dtAbschlussDatum      : TDateTime
      read m_dtAbschlussDatum       write m_dtAbschlussDatum;   
    property sTitel                : string
      read m_sTitel                 write m_sTitel;
    property iStatus               : Integer
      read m_iStatus                write m_iStatus;
    property iBoersenNummer        : Integer
      read m_iBoersenNummer         write m_iBoersenNummer;
    property VerkaufsListe         : TCaoListeVonArtikelListen
      read m_obVerkaufsListe        write m_obVerkaufsListe;
    property fBoerseActive         : Boolean
      read m_fBoerseActive          write m_fBoerseActive;

    //--------------------------------------------------------------------------

    constructor Create;
    destructor  Destroy; override;
    procedure   SaveToDb;
    procedure   LoadFromDb;

    //--------------------------------------------------------------------------

  end; // TCaoBoersenInfo

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

uses
  CaoDatenBank;

//------------------------------------------------------------------------------

var
  obDatenBank: TCaoDatenBank;

//------------------------------------------------------------------------------

constructor TCaoBoersenInfo.Create;
begin
  inherited;
  obDatenBank       := TCaoDatenBank.Create;
  m_obVerkaufsListe := TCaoListeVonArtikelListen.Create;
end;

//------------------------------------------------------------------------------

destructor TCaoBoersenInfo.Destroy;
begin
  obDatenBank.Free;
  m_obVerkaufsListe.Free;
  inherited;
end; // TCaoBoersenInfo.Destroy

//------------------------------------------------------------------------------

procedure TCaoBoersenInfo.LoadFromDb;
begin
  obDatenBank.LoadBoersenInfo(Self);
end; // TCaoBoersenInfo.LoadFromDb

//------------------------------------------------------------------------------

procedure TCaoBoersenInfo.SaveToDb;
begin
  obDatenBank.SaveBoersenInfo(Self);
end; // TCaoBoersenInfo.SaveToDb

//------------------------------------------------------------------------------

end. // CaoBoersenInfo
